;This program is free software: you can redistribute it and/or modify
;it under the terms of the Attribution-NonCommercial 4.0 International
;as published by Creative Commons.
 
 ;This program is distributed in the hope that it will be useful,
 ;but WITHOUT ANY WARRANTY; without even the implied warranty of
 ;MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 ;
 ;You should have received a copy of the  Attribution-NonCommercial 4.0 International as published by
 ;Creative Commons or visit http://creativecommons.org/licenses/by-nc/4.0/

; Original Author: Jeffrey Nygaard
; Company: Northern Lights Electronic Design, LLC
; Contact: JNygaard@NLEDShop.com
; Date Updated: March 3, 2015 
; Webpage: www.NLEDShop.com/extdisplay

; EDITED BY CHROMATION SYSTEMS 3/9/2015
; Edited the open source code available at the address above to make a relay timer.
; Once powered using either of the two buttons on the LED display adjust the time for the relay to be on up or down
; Pressing the 3rd(added) button will turn the relay on and start a counter, when it reaches the set value the relay turns off


	LIST      P=PIC16F1824          ; list directive to define processor
	#INCLUDE <P16F1824.INC>         ; processor specific variable definitions

	__CONFIG _CONFIG1, _FOSC_INTOSC & _WDTE_OFF & _PWRTE_ON & _MCLRE_OFF & _CP_ON & _CPD_OFF & _BOREN_OFF & _CLKOUTEN_OFF & _IESO_OFF & _FCMEN_OFF
	__CONFIG _CONFIG2, _WRT_OFF & _PLLEN_ON & _STVREN_OFF & _BORV_19 & _LVP_OFF

	errorlevel -207
	errorlevel -203
	errorlevel -205
	errorlevel -302

CBLOCK 0x20 ;max 80 bytes in bank 0
	REG_Y
	REG_Z	
	DivisorCalc
	MathVar1
	MathVar3
	MathVar4
	DimHold
	CalcColor
	FinalColor
	PrimResult
	PrimRem
	SecResult
	SecRem

	Place1
	Place2
	Place3		
	DigitMathLo
	DigitMathHi
	ENDC

CBLOCK 0xA0 ;32 RAM Bytes
;Calculation Vars

	ENDC

CBLOCK 0x70 ;16 bytes shared space
	Flags
	Timer
	TimerNest
	SetTime
	
	FrameWork
	DigitSelect
	DigitRecieved
	
	Char1
	Char2
	Char3

	ResetCounter
	ResetCounterNest

	buttonTally1
	buttonTally2
	buttonTally3
	ENDC
	
;TLC5916 Defines
#define CLK LATA,1
#define OE LATC,4 
#define SDO LATA,0
#define LE LATA,2

;RA4, RA5, RC5 = Transistor switches
#define Digit1 LATC,5
#define Digit2 LATA,4
#define Digit3 LATA,5

;#define TXpin LATC,4
;#define RXpin LATC,5
;#define GenIO1 LATA,0 ; RC0 on test program, SRL
;#define GenIO2 LATA,1 ;RC2 on test program, CLK

;connections:
;5 to 7
;10 to 6

#define Button1 PORTC, 0
#define Button2 PORTC, 2
#define Button3 PORTA, 3 ;MCLR 

#define RelayOutput LATC, 3
;#define PiezoOutput LATC,  1 ;not used

#define SRLIn PORTA,1 ; RC0 on test program, SRL
#define CLKIn PORTA,0 ;RC2 on test program, CLK

#define cTMR2FULL b'00111110' ;1:8 post, 1:16 pre, TMRON, 6.55mS
#define cTMR2DIM  b'00001100' ;1:2 post, 1:1 pre, TMRON, DIM

#define cResetValue .2

#define RunningFlag Flags, 0
#define NotifyFlag Flags, 1
#define button1LockOut Flags, 2
#define button2LockOut Flags, 3
#define button3LockOut Flags, 4

#define		BANK0		movlb .0 ;should be bank 0

;V.3 NEW PINs:
;1 = V+
;2 = V-
;3 = RC1 - SPI DataIn
;4 = RC3 - SlaveSelect
;5 = RC0 - SPI CLK
;6 = RC2 - SPI DataOut
;7 = SW1
;8 = RA3/MCLR
;9 = unconnected/key
;10 = SW2

ORG 0x000	
	PAGESEL Initialize
	goto Initialize

ORG		0x004 ;INTERRUPT VECTOR	
	;setup Timer Offset right away, so adding or removing code doesn't alter timer value
	banksel TMR1L
	clrf TMR1L
	clrf TMR1H
	movlw .255
	movwf TMR1L
	BSF TMR1H,3

	;run nest since it interrupts every 100mS, run 10 times per second
	incf TimerNest, f
	movfw TimerNest
	xorlw .16
	BTFSS STATUS, Z
		bra INTX
	;second elapsed

;test for notify which displays --- for 1 second
	BTFSS NotifyFlag
		bra ISRb
;last second it went to dashes, now display set time and disable timer	
	BCF NotifyFlag
	
	movfw SetTime
		call FillDigits
	
	banksel PIE1
	BCF PIE1, TMR1IE ;disable Timer interrupt
		bra INTX ;leave ISR

ISRb
	clrf TimerNest
	incf Timer, f
	
	;test Timer vs SetTime
	movfw Timer
	xorwf  SetTime, w
	BTFSS STATUS, Z
		bra ISRa
	;timer has elapsed
	
	banksel LATC
	BCF RelayOutput
	
	movlw .48 ;dash on all digits
	movwf Char1
	movwf Char2
	movwf Char3
	BSF NotifyFlag
	BCF RunningFlag	
		bra INTX

ISRa
	;update with current time
	movfw Timer
		call FillDigits

INTX
	banksel PIR1
	BCF PIR1, TMR1IF ;clear flag
		retfie ;returns and finishes orignal interrupt

;======================= PROGRAM START ====================================
Start
	banksel LATA
	BCF Digit1
	BCF Digit2
	BCF Digit3

;DP - D - C - E - A - F - B - G
	;initialize with all dashes displayed, user can alter to add custom 3 digit start up msg
	BANK0
	movlw .48 ;dash
	movwf Char1
	
	movlw .48 ;dash
	movwf Char2
	
	movlw .48 ;dash
	movwf Char3	

	;init variables
	movlw .3
	movwf DigitSelect ;starting digit

	movlw .2
	movwf DigitRecieved

	clrf Timer
	clrf TimerNest
	
	movlw .20
	movwf SetTime
	
	clrf Flags
	
	movlw .240
	movwf buttonTally1
	movwf buttonTally2
	movwf buttonTally3

	banksel LATC
	BCF OE ;Low=Output Drivers Enabled, High=Output Drivers Blanked
	banksel LATA
	BSF LE
	
;enter TLC5916 into normal mode.....	it works, not sure if 100% correct but works
	banksel LATA
	BCF CLK
	banksel LATC	
	BSF OE
	
	call NopDelay
	
	banksel LATC	
	BSF CLK
	
	call NopDelay
	banksel LATC	
	BCF CLK	
	
	banksel LATC
	BCF OE	
;end Normal Mode Configw

	BSF INTCON, GIE ;init Interrupts
	BSF INTCON, PEIE	
	BANK0

;setup relay timer stuff
	banksel LATC
	BCF RelayOutput
	
	BSF RunningFlag
	banksel PIR1
	BCF PIR1, TMR1IF ;clear flag
	banksel PIE1
	BSF PIE1, TMR1IE ;enable interrupt
	BCF NotifyFlag ;start set so it display

;User presses button3 to start the timer, displays time
;if not running displays the set time
;if not running, button1 inc/dec SetTime
;if not running, button1 inc/dec SetTime
	
;Main Loop: Monitors for DrawFlag to push the next digit, drawflag is set by TMR2 Interrupt
	;As digits are pushed, a counter is ran and if new data isn't received before counter elapses
	;	it resets the Character Buffer variable to frame incoming data
Main
	banksel PIR1
	BTFSS PIR1, TMR2IF
		bra Main
	call Draw7Segment

;test buttons, all 3....
;button1 and button2 can't be pressed during runtime but button3 can be
	BTFSC RunningFlag
		bra Mb
	
	;=================
	banksel PORTC
	BTFSS Button1
	call ButtonHandler1
	
	BTFSS button1LockOut
		bra Ma
	
	banksel PORTC
	BTFSS Button1
		bra Ma
	BCF button1LockOut
	;=================
Ma
	banksel PORTC	
	BTFSS Button2
	call ButtonHandler2
	
	BTFSS button2LockOut
		bra Mb
	
	banksel PORTC
	BTFSS Button2
		bra Mb
	BCF button2LockOut
	;=================
Mb	
	banksel PORTA
	BTFSS Button3
	call ButtonHandler3	
	
	BTFSS button3LockOut
		bra Mc
	
	banksel PORTA
	BTFSS Button3
		bra Mb
	BCF button3LockOut
	;=================
Mc
	bra Main

;==================================

ButtonHandler1
	BTFSC button1LockOut
		return
	
	incfsz buttonTally1, f
		return
	;button 1 is pressed
	
	incf SetTime, f
	movfw SetTime
	call FillDigits
	
	BSF button1LockOut
	movlw .240
	movwf buttonTally1
		return

ButtonHandler2
	BTFSC button2LockOut
		return
	
	incfsz buttonTally2, f
		return
	;button 2 is pressed
	
	decf SetTime, f
	movfw SetTime
	call FillDigits
		
	BSF button2LockOut
	movlw .240
	movwf buttonTally2
		return

ButtonHandler3
	BTFSC button3LockOut
		return
	incfsz buttonTally3, f
	return
	;button 3 is pressed
	
	BTFSC RunningFlag
		bra BH3a
		
	;start timer
	BSF RunningFlag
	banksel LATC
	BSF RelayOutput
	bra BH3b

BH3a
	BSF NotifyFlag
	BCF RunningFlag
	banksel LATC
	BCF RelayOutput

BH3b
	banksel TMR1H
	clrf TMR1H
	clrf TMR1L
	
	clrf Timer
	clrf TimerNest
	
	banksel PIR1
	BCF PIR1, TMR1IF ;clear flag
	banksel PIE1
	BSF PIE1, TMR1IE ;enable interrupt

BH3c
	BSF button3LockOut
	movlw .230
	movwf buttonTally3
		return

;==================================

FillDigits
	BANK0
	movwf DigitMathLo
	clrf DigitMathHi
	call FigureDigits
	
	movfw Place1
	BTFSC STATUS, Z
		bra $+3
	movwf Char1
		bra $+3
	movlw .36 ;space
	movwf Char1
		
	movfw Place2
	BTFSC STATUS, Z
		bra $+3
	movwf Char2
		bra $+3
	movlw .36 ;space
	movwf Char2
	
	movfw Place3
	movwf Char3
		return

Draw7Segment
	BCF PIR1, TMR2IF
	banksel TMR2
	clrf TMR2

	banksel LATA
	BSF LE
	banksel LATC	
	BSF OE
		
	decfsz DigitSelect,f
		bra D7Sa
		
	movlw .3
	movwf DigitSelect
	
D7Sa
	banksel LATC
	movfw DigitSelect
	brw ;table branch with DigitSelect
	nop	;no 0
	bra Ch3
	bra Ch2
	bra Ch1
		
Ch1
	banksel LATA
	BCF Digit2
	BCF Digit3
	banksel LATC	
	BSF Digit1	
	BANK0	
	
	movfw Char1
	call CharacterMapTable
		bra RunShift

Ch2
	banksel LATC	
	BCF Digit1
	banksel LATA	
	BCF Digit3
	BSF Digit2
	BANK0		
		
	movfw Char2
	call CharacterMapTable
		bra RunShift

Ch3
	banksel LATC	
	BCF Digit1
	banksel LATA	
	BCF Digit2
	BSF Digit3
	
	;counts number of digit draws, and wi	
	decfsz ResetCounter,f
	bra Ch3a

	movlw .2
	movwf DigitRecieved	
		
	movlw cResetValue
	movwf ResetCounter	
	
Ch3a	
	BANK0		
	movfw Char3
	call CharacterMapTable
		bra RunShift	
		
RunShift
;send data to TLC5916 with bit-banging
	movwf FrameWork

	banksel LATC
	BTFSC FrameWork,7 ;checks if the retrived data's bit 7
	BSF SDO ; is 1, if it is, SDO pin is set, and the shift register is 
	call ShiftRegister ; incremented, SDO is then returned to 0 state
					; by ShiftRegister call

	BTFSC FrameWork,6 ;repeats with all the bits
	BSF SDO
	call ShiftRegister

	BTFSC FrameWork,5
	BSF SDO
	call ShiftRegister

	BTFSC FrameWork,4
	BSF SDO
	call ShiftRegister

	BTFSC FrameWork,3
	BSF SDO
	call ShiftRegister

	BTFSC FrameWork,2
	BSF SDO
	call ShiftRegister

	BTFSC FrameWork,1
	BSF SDO
	call ShiftRegister

	BTFSC FrameWork,0
	BSF SDO
	call ShiftRegister

	banksel LATA
	BCF LE ; enable outputs
	banksel LATC	
	BCF OE
		return;goto Main

ShiftRegister ;increment the register
	banksel LATC	
	BSF CLK ; make CLK pin high
	call NopDelay
	call NopDelay		
	BCF CLK
	BCF SDO ;return SDO pin to Low
	call NopDelay
	call NopDelay		
		return

NopDelay ;delay routine
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	return

Initialize
	banksel PIE1
	clrf PIE1
	banksel IOCAP
	clrf IOCAP
	banksel IOCAN
	clrf IOCAN
	banksel CPSCON0
	clrf CPSCON0
	banksel T1GCON
	clrf T1GCON
	banksel CM1CON0
	clrf CM1CON0
	banksel CM1CON1
	clrf CM1CON1
	banksel CCP1CON
	clrf CCP1CON
	banksel CCP2CON
	clrf CCP2CON
	banksel CCP3CON
	clrf CCP3CON

 	banksel INTCON
       movlw   b'00000000' ;set peripherial interrupts, not GIE yet'
       movwf   INTCON
        
	banksel OSCCON
	movlw b'11110000' ;set for 8mhz
	movwf OSCCON

	; set up A/D converter
	banksel ADCON1
	clrf ADCON1

	banksel ADCON0 ;good SDO, SS, CLK, SDI
	clrf  ADCON0

	banksel ANSELA
	clrf ANSELA
	
	banksel ANSELC
	CLRF ANSELC	

	; set up direction of I/O pins
	banksel TRISA
	movlw b'00001000'
	movwf TRISA ;all outputs

	banksel TRISC	
	movlw b'00000101'
	movwf TRISC

	banksel OPTION_REG
	movlw b'10000000' ;WPUx internal pullups enable
	movwf OPTION_REG

	banksel WPUA
	movlw b'00000000' ;enable MCLR weak pull ups
	movwf WPUA

	banksel WPUC
	movlw b'00000000'
	movwf WPUC
	
	banksel APFCON0 ;default pin settings
	clrf APFCON0
	banksel APFCON1
	clrf APFCON1

	;setup TMR2
	banksel T2CON
	movlw cTMR2FULL ;1:8 post, 1:16 pre, TMRON, 6.55mS
	movwf T2CON
	
	;setup timer 1 for slowest
	banksel T1CON
	movlw b'00110001' ;FOSC/4, 1:8, tmron
	movwf T1CON
	goto Start

FigureDigits ;converts 3 digit address into 3 digit character display
	BANK0
	clrf Place1
	clrf Place2
	clrf Place3

	movfw DigitMathLo
	movwf REG_Z
	movlw .100
	movwf DivisorCalc

	pagesel MyDivide
	call MyDivide ;divide address by 100 to find 1st digit.

	movfw REG_Y
	movwf  Place1

	movlw .10
	movwf DivisorCalc

	pagesel MyDivide	
	call MyDivide ;divide remainder by 10 to find the second digit.
	
	movfw REG_Y
	movwf  Place2
	
	movfw REG_Z
	movwf  Place3
	
	BTFSS DigitMathHi,0 ;addressHi, 0 ;check hi bit
		return ;if its 0 return, address is lower
	movlw .6 ;was 5
	addwf Place3,f
	movf Place3,w
	addlw .246 ;if place 3 is larger than 9=
	BTFSS STATUS, C 	;	bnc Dig2 ;didn't carry its less than 9
	bra Dig2
	;check if its 10 make it 0 and inc
	movlw .10 ;subtract 10 from Place3
	subwf Place3,f ;if its 0 then Place3 was10, set Place3 to 0 and Inc Place2
	BTFSC STATUS,Z ;bz Pla0
	bra Pla0
	;if it isn't 0, result is placed in place3(13-10=3
	incf Place2,f ;incresae place2 by 10 = 1
		bra Dig2

Pla0
	clrf Place3 ;make Place 3 0
	incf Place2,f ;increase Place2

Dig2
	movlw .5
	addwf Place2,f
	movf Place2,w
	addlw .246 ;if place 2 is larger than 9
	BTFSS STATUS, C 	;bnc Dig3 ;didn't carry its less than 9
	bra Dig3
	;check if its 10 make it 0 and inc
	movlw .10 ;subtract 10 from Place3
	subwf Place2,f ;if its 0 then Place3 was10, set Place3 to 0 and Inc Place2
	BTFSC STATUS,Z 
	bra Pla1
	;if it isn't 0, result is placed in place3(13-10=3
	incf Place1,f ;incresae place2 by 10 = 1
	bra Dig3

Pla1
	clrf Place2 ;make Place 2= 0
	incf Place1,f ;increase Place1

 Dig3
	;2 is added to Place1 along with any addtionals.
	movlw .2
	addwf Place1,f
		return		


;--------- START OF MATH FUNCTIONS ---------
MyDivide  ; divide Z by X, result in Y, remainder in Z
	clrf REG_Y

	movfw DivisorCalc
	BTFSC STATUS,Z 	;bz  DivideDone0 ;if Divisor is 0, gotonch to done
	bra DivideDone0 

	movfw DivisorCalc
	xorlw .1
	BTFSC STATUS,Z
	bra DivideOne

	movfw DivisorCalc
	xorlw .2
	BTFSC STATUS,Z
	bra DivideTwo
T1
	movfw REG_Z
	movwf MathVar3 ;store value

	movfw DivisorCalc
	subwf REG_Z,f 
	BTFSS STATUS,C ;will be set unless result carrys
		bra DivideDone
	incf REG_Y,f ;was Counter
		bra T1

DivideDone
	movfw MathVar3
        movwf   REG_Z
		return

DivideDone0
	movfw REG_Z
       movwf  REG_Y ;if x=0 then Y = Z
	clrf REG_Z ; no remainder
		return

DivideOne
	movfw REG_Z
       movwf  REG_Y ;if x=1 then Y = Z
	clrf REG_Z ; no remainder
		return

DivideTwo ;if X is 2, then divide Z by 2 drop remainder
       rrf REG_Z,f
	bcf REG_Z, 7
	movfw REG_Z
       movwf  REG_Y ;if x=1 then Y = Z
		return

	#include "romdata.inc" ;holds character map

	END	
